Rem
Rem $Header: mgw/samples/mq/mq_adm_setup.sql /mgw_main/3 2012/08/11 01:05:15 pabhat Exp $
Rem
Rem mq_adm_setup.sql
Rem
Rem Copyright (c) 2003, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      mq_adm_setup.sql - SQL script to configure MGW entities.
Rem
Rem    DESCRIPTION
Rem      This script sets up a "round-trip" propagation to illustrate both
Rem      outbound (AQ->MQ) and inbound (MQ->AQ) propagation. An outbound 
Rem      propagation job moves messages from the AQ queue MGWUSER.MGW_BASIC_SRC
Rem      to a user supplied WebSphere MQ queue. An inbound propagation job
Rem      messages from the same user supplied WebSphere MQ queue to the AQ
Rem      queue MGWUSER.MGW_BASIC_DEST. The end result should be messages 
Rem      moved from MGWUSER.MGW_BASIC_SRC to MGWUSER.MGW_BASIC_DEST.
Rem
Rem PREREQUISITES:
Rem
Rem * The following database entities are assumed:
Rem   - Users: mgwagent, mgwadm, mgwuser
Rem   - AQ Queues: mgwuser.mgw_basic_src, mgwuser.mgw_basic_dest
Rem
Rem --------------------------------------------------------------------------
Rem
Rem This script does the following (via the dbms_mgwadm package):
Rem
Rem * Sets the agent user connection information:
Rem   username: mgwagent
Rem   password: mgwagent
Rem   database: <user supplied>
Rem
Rem * Creates an WebSphere MQ link
Rem   Link name: mqlink
Rem
Rem * Creates an WebSphere MQ foreign queue.
Rem   Name:   destq
Rem   Link:   mqlink
Rem   Native: <user supplied>
Rem
Rem * Creates an OUTBOUND propagation job.
Rem   Job:    job_aq2mq
Rem   Source: mgwuser.mgw_basic_src
Rem   Dest:   destq@mqlink
Rem
Rem * Creates an INBOUND propagation job.
Rem   Job:    job_mq2aq
Rem   Source: destq@mqlink
Rem   Dest:   mgwuser.mgw_basic_dest
Rem
Rem ==========================================================================

connect mgwadm/mgwadm;

variable gv_database            VARCHAR2(32);
variable gv_mq_queue_manager    VARCHAR2(32);
variable gv_mq_queue_name       VARCHAR2(32);
variable gv_mq_channel          VARCHAR2(32);
variable gv_mq_inbound_log_queue  VARCHAR2(32);
variable gv_mq_outbound_log_queue VARCHAR2(32);
variable gv_mq_username         VARCHAR2(32);
variable gv_mq_password         VARCHAR2(32);
variable gv_mq_host             VARCHAR2(48);
variable gv_mq_port             VARCHAR2(6);

--
-- WARNING!!!! The values below must be set before this script is run.
--
begin
  :gv_database         := '';     -- database specifier for agent user
  :gv_mq_queue_manager := '';
  :gv_mq_queue_name    := '';
  :gv_mq_channel       := '';
  :gv_mq_host          := '';
  :gv_mq_port          := '';
  :gv_mq_username      := '';  -- must be non-NULL for WebSphere MQ 6.0
  :gv_mq_password      := '';
  :gv_mq_inbound_log_queue  := '';
  :gv_mq_outbound_log_queue := '';
end;
/

prompt
prompt Setting the gateway agent user for the default agent
prompt 

rem   If we do not set the database argument it will default to the
rem   ORACLE_SID of the MGW process (the listener process).
begin
  dbms_mgwadm.alter_agent(
      agent_name => 'default_agent',
      username   => 'mgwagent',
      password   => 'mgwagent',
      database   => RTRIM(:gv_database));
end;
/

prompt
prompt Creating MQSeries link
prompt

declare
  v_options sys.mgw_properties := NULL;
  v_prop    sys.mgw_mqseries_properties;
begin
  if (:gv_mq_queue_manager IS NULL) then
    dbms_output.put_line('queue manager must be specified');
  end if;

  -- set options if desired

  -- set certain mqseries properties used for MQSeries
  -- NOTE: This information must be changed for your MQSeries setup.
  v_prop := sys.mgw_mqseries_properties.construct();

  v_prop.max_connections := 1;

  -- queue manager name (required)
  v_prop.queue_manager := RTRIM(:gv_mq_queue_manager);

   -- hostname for queue manager host (required)
  v_prop.hostname := RTRIM(:gv_mq_host);

  -- channel name (required)
  v_prop.channel  := RTRIM(:gv_mq_channel);

  -- port (required -- 1414 is MQSeries default)
  v_prop.port := RTRIM(:gv_mq_port);

  -- username given to queue manager
  if (:gv_mq_username IS NOT NULL) then
    v_prop.username := RTRIM(:gv_mq_username);
  end if;

  -- password given to queue manager
  if (:gv_mq_password IS NOT NULL) then
    v_prop.password := RTRIM(:gv_mq_password);
  end if;

  -- name of MQSeries queue to be used for MGW logging on inbound jobs
  if (:gv_mq_inbound_log_queue IS NOT NULL) then
    v_prop.inbound_log_queue := RTRIM(:gv_mq_inbound_log_queue);
  end if;

  -- name of MQSeries queue to be used for MGW logging on outbound jobs
  if (:gv_mq_outbound_log_queue IS NOT NULL) then
    v_prop.outbound_log_queue := RTRIM(:gv_mq_outbound_log_queue);
  end if;

  -- create link
  dbms_mgwadm.create_msgsystem_link(
      linkname   => 'mqlink',          -- link name
      agent_name => 'default_agent',   -- MGW agent responsible for this link
      properties => v_prop,            -- WebSphere MQ driver properties
      options    => v_options);        -- optional link options
end;
/

prompt
prompt Registering foreign queue
prompt

declare
  v_options sys.mgw_properties;
begin
  -- Set options for register foreign queue
  --  MQ_openOptions: 2066 is TODO
  v_options := sys.mgw_properties(
        sys.mgw_property('MQ_openOptions', '2066') );

  dbms_mgwadm.register_foreign_queue(
      name     => 'destq',                   -- MGW foreign queue name
      linkname => 'mqlink',                  -- name of link to use
      provider_queue => RTRIM(:gv_mq_queue_name), -- name of MQSeries queue
      domain   => dbms_mgwadm.DOMAIN_QUEUE,  -- single consumer queue
      options  => v_options );
end;
/

prompt
prompt Adding outbound propagation job
prompt

begin
  -- source must be an AQ queue (schema.name)
  -- destination must be a registered non-Oracle queue (queue@link)
  -- subscriber rule applies to AQ subscriber
  -- exception queue, if any, must be a NORMAL AQ queue with same payload
  --   type as the source queue (schema.name)
  --
  -- for this sample:
  -- no selection rule used for this job
  -- no transformation invoked on AQ dequeue
  -- no exception queue
  dbms_mgwadm.create_job(
      job_name    => 'job_aq2mq',
      propagation_type => dbms_mgwadm.outbound_propagation,
      source      => 'mgwuser.mgw_basic_src',  -- AQ queue
      destination => 'destq@mqlink');          -- registered non-Oracle queue
end;
/

prompt
prompt Adding inbound propagation job
prompt

begin
  -- source must be a registered non-Oracle queue (queue@link)
  -- destination must be an AQ queue (schema.name)
  -- exception queue, if any, must be a registered non-Oracle queue that
  --   uses the same link as the source queue (queue@link)
  --
  -- for this sample:
  -- no selection rule can be used for this job
  -- no transformation invoked on AQ enqueue
  -- no exception queue
  dbms_mgwadm.create_job(
      job_name    => 'job_mq2aq',
      propagation_type => dbms_mgwadm.inbound_propagation,
      source      => 'destq@mqlink',            -- registered non-Oracle queue
      destination => 'mgwuser.mgw_basic_dest'); -- AQ queue
end;
/

